<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjects\Tests;

use ExportObjects\Config\Client;

require_once __DIR__ . '/TestBase.php';
require_once __DIR__ . '/PrivacyHelper.php';

/**
 * Test Value Mappers
 *
 * @package ExportObjects\Tests
 */
class ValueMapperTest extends TestBase
{

    public function testArea()
    {$this->markTestSkipped();
        $client = $this->getClient();
        $objectMapper = $this->getObjectMapper();
        $configProperty = $this->getConfigProperty('datenblattApsiden', 'area', 'qm');

        $configPropertyModifier = new PrivacyHelper($configProperty);

        $configPropertyModifier->unitValue = 'qkm';
        $objectMapper->getObject()->setDatenblattApsiden(1);
        $this->assertEquals(1000000, $this->apiM()->valuemapper()->area($client)->map($objectMapper, $configProperty, ''));

        $configPropertyModifier->unitValue = 'qm';
        $objectMapper->getObject()->setDatenblattApsiden(1);
        $this->assertEquals(1, $this->apiM()->valuemapper()->area($client)->map($objectMapper, $configProperty, ''));

        $configPropertyModifier->unitValue = 'qmm';
        $objectMapper->getObject()->setDatenblattApsiden(1000000);
        $this->assertEquals(1, $this->apiM()->valuemapper()->area($client)->map($objectMapper, $configProperty, ''));
    }

    public function testEnergy()
    {$this->markTestSkipped();
        $client = $this->getClient();
        $objectMapper = $this->getObjectMapper();
        $configProperty = $this->getConfigProperty('datenblattApsiden', 'energy', 'Wh');

        $configPropertyModifier = new PrivacyHelper($configProperty);

        $configPropertyModifier->unitValue = 'Wh';
        $objectMapper->getObject()->setDatenblattApsiden(1);
        $this->assertEquals(1, $this->apiM()->valuemapper()->energy($client)->map($objectMapper, $configProperty, ''));

        $configPropertyModifier->unitValue = 'kWh';
        $objectMapper->getObject()->setDatenblattApsiden(1);
        $this->assertEquals(1000, $this->apiM()->valuemapper()->energy($client)->map($objectMapper, $configProperty, ''));

        $configPropertyModifier->unitValue = 'mWh';
        $objectMapper->getObject()->setDatenblattApsiden(1);
        $this->assertEquals(0.001, $this->apiM()->valuemapper()->energy($client)->map($objectMapper, $configProperty, ''));
    }

    public function testLength()
    {$this->markTestSkipped();
        $client = $this->getClient();
        $objectMapper = $this->getObjectMapper();
        $configProperty = $this->getConfigProperty('datenblattApsiden', 'length', 'mm');

        $configPropertyModifier = new PrivacyHelper($configProperty);

        $configPropertyModifier->unitValue = 'mm';
        $objectMapper->getObject()->setDatenblattApsiden(2);
        $this->assertEquals(2, $this->apiM()->valuemapper()->length($client)->map($objectMapper, $configProperty, ''));

        $configPropertyModifier->unitValue = 'm';
        $objectMapper->getObject()->setDatenblattApsiden(2);
        $this->assertEquals(2000, $this->apiM()->valuemapper()->length($client)->map($objectMapper, $configProperty, ''));

        $configPropertyModifier->unitValue = 'km';
        $objectMapper->getObject()->setDatenblattApsiden(2);
        $this->assertEquals(2000000, $this->apiM()->valuemapper()->length($client)->map($objectMapper, $configProperty, ''));
    }

    public function testLuminousFlux()
    {$this->markTestSkipped();
        $client = $this->getClient();
        $objectMapper = $this->getObjectMapper();
        $configProperty = $this->getConfigProperty('datenblattApsiden', 'luminousFlux', 'lm');

        $configPropertyModifier = new PrivacyHelper($configProperty);

        $configPropertyModifier->unitValue = 'lm';
        $objectMapper->getObject()->setDatenblattApsiden(20);
        $this->assertEquals(20, $this->apiM()->valuemapper()->luminousFlux($client)->map($objectMapper, $configProperty, ''));
    }

    public function testMass()
    {$this->markTestSkipped();
        $client = $this->getClient();
        $objectMapper = $this->getObjectMapper();
        $configProperty = $this->getConfigProperty('datenblattApsiden', 'mass', 'g');

        $configPropertyModifier = new PrivacyHelper($configProperty);

        $configPropertyModifier->unitValue = 'g';
        $objectMapper->getObject()->setDatenblattApsiden(1);
        $this->assertEquals(1, $this->apiM()->valuemapper()->mass($client)->map($objectMapper, $configProperty, ''));

        $configPropertyModifier->unitValue = 'kg';
        $objectMapper->getObject()->setDatenblattApsiden(1);
        $this->assertEquals(1000, $this->apiM()->valuemapper()->mass($client)->map($objectMapper, $configProperty, ''));

        $configPropertyModifier->unitValue = 't';
        $objectMapper->getObject()->setDatenblattApsiden(1);
        $this->assertEquals(1000000, $this->apiM()->valuemapper()->mass($client)->map($objectMapper, $configProperty, ''));
    }

    public function testPower()
    {$this->markTestSkipped();
        $client = $this->getClient();
        $objectMapper = $this->getObjectMapper();
        $configProperty = $this->getConfigProperty('datenblattApsiden', 'power', 'gW');

        $configPropertyModifier = new PrivacyHelper($configProperty);

        $configPropertyModifier->unitValue = 'mW';
        $objectMapper->getObject()->setDatenblattApsiden(1);
        $this->assertEquals(0.001, $this->apiM()->valuemapper()->power($client)->map($objectMapper, $configProperty, ''));

        $configPropertyModifier->unitValue = 'W';
        $objectMapper->getObject()->setDatenblattApsiden(1);
        $this->assertEquals(1, $this->apiM()->valuemapper()->power($client)->map($objectMapper, $configProperty, ''));

        $configPropertyModifier->unitValue = 'kW';
        $objectMapper->getObject()->setDatenblattApsiden(1);
        $this->assertEquals(1000, $this->apiM()->valuemapper()->power($client)->map($objectMapper, $configProperty, ''));

        $configPropertyModifier->unitValue = 'MW';
        $objectMapper->getObject()->setDatenblattApsiden(1);
        $this->assertEquals(1000000, $this->apiM()->valuemapper()->power($client)->map($objectMapper, $configProperty, ''));
    }

    public function testTemperature()
    {$this->markTestSkipped();
        $client = $this->getClient();
        $objectMapper = $this->getObjectMapper();
        $configProperty = $this->getConfigProperty('datenblattApsiden', 'temperature', 'C');

        $configPropertyModifier = new PrivacyHelper($configProperty);

        $configPropertyModifier->unitValue = 'F';
        $objectMapper->getObject()->setDatenblattApsiden(1);
        $this->assertEquals(-17.2, round($this->apiM()->valuemapper()->temperature($client)->map($objectMapper, $configProperty, ''),1));
    }

    public function testTime()
    {$this->markTestSkipped();
        $client = $this->getClient();
        $objectMapper = $this->getObjectMapper();
        $configProperty = $this->getConfigProperty('datenblattApsiden', 'time', 's');

        $configPropertyModifier = new PrivacyHelper($configProperty);

        $configPropertyModifier->unitValue = 's';
        $objectMapper->getObject()->setDatenblattApsiden(30);
        $this->assertEquals(30, $this->apiM()->valuemapper()->time($client)->map($objectMapper, $configProperty, ''));

        $configPropertyModifier->unitValue = 'min';
        $objectMapper->getObject()->setDatenblattApsiden(30);
        $this->assertEquals(1800, $this->apiM()->valuemapper()->time($client)->map($objectMapper, $configProperty, ''));

        $configPropertyModifier->unitValue = 'h';
        $objectMapper->getObject()->setDatenblattApsiden(0.5);
        $this->assertEquals(1800, $this->apiM()->valuemapper()->time($client)->map($objectMapper, $configProperty, ''));

        $configPropertyModifier->unitValue = 'd';
        $objectMapper->getObject()->setDatenblattApsiden(1);
        $this->assertEquals(86400, $this->apiM()->valuemapper()->time($client)->map($objectMapper, $configProperty, ''));

        $configPropertyModifier->unitValue = 'Y';
        $objectMapper->getObject()->setDatenblattApsiden(1);
        $this->assertEquals(31536000, $this->apiM()->valuemapper()->time($client)->map($objectMapper, $configProperty, ''));
    }

    /**
     * @return \ExportObjects\Mapper\Mapper
     */
    private function getObjectMapper()
    {
        $datenblatt = new \Pimcore\Model\Object\Datenblatt();
        $datenblatt->setDatenblattDicke(1000);
        return $this->apiM()->mapper()->object($datenblatt);
    }

    /**
     * @param string $id
     * @param string $mapper
     * @param string $baseUnit
     * @return \ExportObjects\Config\Objects\Property
     */
    private function getConfigProperty($id, $mapper, $baseUnit)
    {
        $xml = '<?xml version="1.0" encoding="UTF-8"?>'
            . '<Property>'
            . '<Id>' . $id . '</Id>'
            . '<Mapper>' . $mapper . '</Mapper>'
            . '<BaseUnit>' . $baseUnit . '</BaseUnit>'
            . '</Property>';
        $property = $this->apiM()->serializer()->deserialize($xml, 'ExportObjects\Config\Objects\Property', 'xml');

        return $property;
    }

    /**
     * @return Client
     */
    private function getClient()
    {
        return $this->apiM()->clients()->configured()->first();
    }
}
