<?php
/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjects\Config;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Objects Configuration
 *
 * @package ExportObjects\Config
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Objects
{

    /**
     * @Serializer\SerializedName("Object")
     * @Serializer\Type("ArrayCollection<ExportObjects\Config\Objects\Object>")
     * @Serializer\XmlList(inline=true, entry="Object")
     *
     * @var Objects\Object[]
     */
    private $object;

    /**
     * @return \Doctrine\Common\Collections\ArrayCollection<Object>
     */
    public function getObject()
    {

        return $this->object;
    }

    /**
     * @param \Doctrine\Common\Collections\ArrayCollection<Object> $object
     *
     * @return Objects
     */
    public function setObject($object)
    {

        $this->object = $object;

        return $this;
    }
}
