<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace ExportObjects\Config\Objects;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Document
 *
 * @package ExportObjects\Config\Objects
 */
class Document
{

    /**
     * @Serializer\SerializedName("Language")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $language;
    /**
     * @Serializer\SerializedName("Prefix")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $prefix;
    /**
     * @Serializer\SerializedName("Ranking")
     * @Serializer\Type("integer")
     *
     * @var int
     */
    private $ranking;
    /**
     * @Serializer\SerializedName("Text")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $text;
    /**
     * @Serializer\SerializedName("Title")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $title;
    /**
     * @Serializer\SerializedName("Url")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $url;

    /**
     * @return string
     */
    public function getLanguage()
    {

        return $this->language;
    }

    /**
     * @param string $language
     *
     * @return Document
     */
    public function setLanguage($language)
    {

        $this->language = $language;

        return $this;
    }

    /**
     * @return string
     */
    public function getPrefix()
    {

        return $this->prefix;
    }

    /**
     * @param string $prefix
     *
     * @return Document
     */
    public function setPrefix($prefix)
    {

        $this->prefix = $prefix;

        return $this;
    }

    /**
     * @return string
     */
    public function getRanking()
    {

        return $this->ranking;
    }

    /**
     * @param int $ranking
     *
     * @return Document
     */
    public function setRanking($ranking)
    {

        $this->ranking = $ranking;

        return $this;
    }

    /**
     * @return string
     */
    public function getText()
    {

        return $this->text;
    }

    /**
     * @param string $text
     *
     * @return Document
     */
    public function setText($text)
    {

        $this->text = $text;

        return $this;
    }

    /**
     * @return string
     */
    public function getTitle()
    {

        return $this->title;
    }

    /**
     * @param string $title
     *
     * @return Document
     */
    public function setTitle($title)
    {

        $this->title = $title;

        return $this;
    }

    /**
     * @return string
     */
    public function getUrl()
    {

        return $this->url;
    }

    /**
     * @param string $url
     *
     * @return Document
     */
    public function setUrl($url)
    {

        $this->url = $url;

        return $this;
    }
}
