<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace ExportObjects\Config\Objects;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Object
 *
 * @package ExportObjects\Config\Objects
 */
class Object
{

    /**
     * @Serializer\SerializedName("Class")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $class;
    /**
     * @Serializer\SerializedName("Document")
     * @Serializer\Type("ExportObjects\Config\Objects\Document")
     *
     * @var \ExportObjects\Config\Objects\Document
     */
    private $document;
    /**
     * @Serializer\SerializedName("Prefix")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $prefix;
    /**
     * @Serializer\SerializedName("Property")
     * @Serializer\Type("ArrayCollection<ExportObjects\Config\Objects\Property>")
     * @Serializer\XmlList(inline=true, entry="Property")
     * @var Property[]
     */
    private $properties;

    /**
     * @Serializer\SerializedName("ParentObject")
     * @Serializer\Type("ExportObjects\Config\Objects\ParentObject")
     *
     * @var ParentObject
     */
    private $parentObject;


    /**
     * @return string
     */
    public function getClass()
    {

        return $this->class;
    }

    /**
     * @param string $class
     *
     * @return Object
     */
    public function setClass($class)
    {

        $this->class = $class;

        return $this;
    }

    /**
     * @return \ExportObjects\Config\Objects\Document
     */
    public function getDocument()
    {

        return $this->document;
    }

    /**
     * @param Document $document
     *
     * @return Object
     */
    public function setDocument($document)
    {

        $this->document = $document;

        return $this;
    }

    /**
     * @return string
     */
    public function getPrefix()
    {

        return $this->prefix;
    }

    /**
     * @param string $prefix
     *
     * @return Object
     */
    public function setPrefix($prefix)
    {

        $this->prefix = $prefix;

        return $this;
    }

    /**
     * @return \Doctrine\Common\Collections\ArrayCollection<Property>
     */
    public function getProperties()
    {

        return $this->properties;
    }

    /**
     * @param \Doctrine\Common\Collections\ArrayCollection<Property> $properties
     *
     * @return Object
     */
    public function setProperties($properties)
    {

        $this->properties = $properties;

        return $this;
    }

    /**
     * @return ParentObject
     */
    public function getParentObject()
    {

        return $this->parentObject;
    }

    /**
     * @param Document $parentObject
     *
     * @return Object
     */
    public function setParentObject($parentObject)
    {

        $this->parentObject = $parentObject;

        return $this;
    }
}
