<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace ExportObjects\Config\Objects;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class ParentObject
 *
 * @package ExportObjects\Config\Objects
 */
class ParentObject
{

    /**
     * @Serializer\SerializedName("Class")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $class;

    /**
     * @Serializer\SerializedName("Attribute")
     * @Serializer\Type("ArrayCollection<ExportObjects\Config\Objects\ParentObject\Attribute>")
     * @Serializer\XmlList(inline=true, entry="Attribute")
     *
     * @var ParentObject\Attribute[]
     */
    private $attribute;

    /**
     * @return mixed
     */
    public function getClass()
    {

        return $this->class;
    }

    /**
     * @param mixed $class
     *
     * @return ParentObject
     */
    public function setClass($class)
    {

        $this->class = $class;

        return $this;
    }

    /**
     * @return ParentObject\Attribute[]
     */
    public function getAttribute()
    {

        return $this->attribute;
    }

    /**
     * @param ParentObject\Attribute[] $attribute
     *
     * @return ParentObject
     */
    public function setAttribute($attribute)
    {

        $this->attribute = $attribute;

        return $this;
    }
}
