<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace ExportObjects\Config\Objects\ParentObject;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Attribute
 *
 * @package ExportObjects\Config\Objects\ParentObject
 */
class Attribute
{
    /**
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("CleanValue")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $metaData;

    /**
     * @Serializer\SerializedName("Domain")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $domain;

    /**
     * @return string
     */
    public function getName()
    {

        return $this->name;
    }

    /**
     * @param string $name
     *
     * @return Attribute
     */
    public function setName($name)
    {

        $this->name = $name;

        return $this;
    }

    /**
     * @return string
     */
    public function getMetaData()
    {

        return $this->metaData;
    }

    /**
     * @param string $metaData
     *
     * @return Attribute
     */
    public function setMetaData($metaData)
    {

        $this->metaData = $metaData;

        return $this;
    }

    /**
     * @return string
     */
    public function getDomain()
    {

        return $this->domain;
    }

    /**
     * @param string $domain
     *
     * @return Attribute
     */
    public function setDomain($domain)
    {

        $this->domain = $domain;

        return $this;
    }
}
