<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjects\Config;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Config
 *
 * @package ExportObjects\Config
 * @author  Oliver Friedrich <of@life-style.de>
 *
 * @Serializer\XmlRoot("ExportObjects")
 */
class PluginConfig
{
    /**
     * @Serializer\SerializedName("Clients")
     * @Serializer\Type("ArrayCollection<ExportObjects\Config\Client>")
     * @Serializer\XmlList(inline = false, entry = "Client")
     * @var ArrayCollection
     */
    private $clients;

    /**
     * @Serializer\SerializedName("Objects")
     * @Serializer\Type("ExportObjects\Config\Objects")
     * @var Objects
     */
    private $objects;

    /**
     * @return ArrayCollection<Client>
     */
    public function getClients()
    {

        return $this->clients;
    }

    /**
     * @param ArrayCollection<Client> $clients
     *
     * @return PluginConfig
     */
    public function setClients($clients)
    {

        $this->clients = $clients;

        return $this;
    }

    /**
     * @return Objects
     */
    public function getObjects()
    {

        return $this->objects;
    }

    /**
     * @param Objects $objects
     *
     * @return PluginConfig
     */
    public function setObjects($objects)
    {

        $this->objects = $objects;

        return $this;
    }
}
