<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjects\EventListener;

use ExportObjects\Api\Manager as ApiManager;
use Pimcore\Model\Object\Datenblatt;

/**
 * Event-Listener Update-Object
 *
 * @package ExportObjects
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Update implements ListenerInterface
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {

        $this->apiM = $apiM;
    }

    /**
     * Attach event listener
     */
    public function init()
    {

        \Pimcore::getEventManager()->attach("object.postUpdate", array($this, 'update'));
    }

    /**
     * Update objects
     *
     * @param \Zend_EventManager_Event $event
     *
     * @return \Zend_EventManager_Event
     */
    public function update(\Zend_EventManager_Event $event)
    {

        if ($this->hasSubscribed($event)) {
            $this->apiM->logger()->debug('Triggered event update-object');
            $this->apiM->worker()->update()->run($event->getTarget());
        }

        return $event;
    }

    /**
     * @param \Zend_EventManager_Event $event
     *
     * @return bool
     */
    private function hasSubscribed(\Zend_EventManager_Event $event)
    {

        $exportClassConfig = $this->apiM->pluginConfig()->getObjects()->getObject();

        foreach ($exportClassConfig as $exportConfig) {
            $className = $exportConfig->getClass();

            if ($event->getTarget() instanceof $className) {
                $this->apiM->setExportConfig($exportConfig);

                return true;
            }
        }

        return false;
    }
}
