<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjects\Mapper;

use ExportObjects\Api\Manager as ApiManager;
use Pimcore\Model\Object\Fieldcollection\Data\AbstractData as ObjectFieldcollection;

/**
 * Factory for Mapper
 *
 * @package ExportObjects\Mapper
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Factory
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {

        $this->apiM = $apiM;
    }

    /**
     * Create new object-mapper
     *
     * @param object $object
     *
     * @return Mapper
     */
    public function object($object)
    {

        return new Mapper($this->apiM, $object);
    }

    /**
     * Create new object-mapper
     *
     * @param ObjectFieldcollection $objectFieldcollection
     *
     * @return Mapper
     */
    public function fieldCollection(ObjectFieldcollection $objectFieldcollection)
    {

        return new FieldCollection($this->apiM, $objectFieldcollection);
    }
}
