<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjects\ValueMapper;

use ExportObjects\Config\Objects\Property as ConfigProperty;
use ExportObjects\Mapper\Mapper as ObjectMapper;

/**
 * Class Format
 * @package ExportObjects\ValueMapper
 */
class Format extends Base
{

    /**
     * Map value - do sprintf
     *
     * @param ObjectMapper   $objectMapper
     * @param ConfigProperty $property
     * @param string         $language
     *
     * @return mixed
     */
    public function map(ObjectMapper $objectMapper, ConfigProperty $property, $language)
    {
        $params = array(
            $property->getFormat()
        );

        foreach ($property->getValues() as $propertyName) {
            $value = trim($objectMapper->getValue($propertyName));

            // If one of the values is empty, skip
            if (!strlen($value)) {
                return '';
            }

            $params[] = $value;
        }


        return $this->sprintfParametersValid($property->getId(), $propertyName, $params) ? call_user_func_array('sprintf', $params) : '';
    }

    /**
     * @param string $propertyId
     * @param string $propertyName
     * @param array $params
     * @return bool
     */
    private function sprintfParametersValid($propertyId, $propertyName, $params)
    {
        $format = preg_replace('/[^%]/', '', str_replace('%%', '', array_shift($params)));

        if (count($params) != strlen($format)) {
            $this->apiM->logger()->debug(sprintf('Invalid number of value-fields in configuration for datasheet-property "%s (id: %s)"', $propertyName, $propertyId));
            return false;
        }

        return true;
    }
}
