<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjects\Webservice;

use ExportObjects\Api\Manager as ApiManager;
use ExportObjects\Config\Client as ClientConfig;
use ExportObjects\Config\Service as ServiceConfig;
use ExportObjects\Model\Response\ResponseInterface;
use GuzzleHttp\Exception\ClientException;
use GuzzleHttp\Exception\RequestException;

/**
 * Webservice-Request
 *
 * @package ExportObjects\Webservice
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Request
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {

        $this->apiM = $apiM;
    }

    /**
     * @param object        $request
     * @param ClientConfig  $client
     * @param ServiceConfig $service
     *
     * @return ResponseInterface
     * @throws \Exception
     */
    public function send($request, ClientConfig $client, ServiceConfig $service)
    {

        $body = $this->apiM->serializer()->serialize($request, $service->getFormat());

        // Prepare request
        $options = array(
            'headers' => array(
                'Accept' => $service->getAcceptContentType(),
                'Content-Type' => $service->getContentType(),
                'clientid' => $client->getId(),
            ),
            'body' => $body,
        );

        $this->apiM->logger()->info(sprintf('Object export: sending request to client "%s" url %s', $client->getId(), $service->getUrl()));

        $this->apiM->logger()->debug($body);

        /**
         * Send request
         */
        try {
            $method = 'put';

            if (is_a($request, 'Swoox\Api\Model\Request\Delete\Swoox\Request')) {
                $method = 'delete';
            }

            $webserviceResponse = $this->apiM->webservice()->client()->$method($service->getUrl(), $options);
        } catch (ClientException $exception) {
            /**
             * Received an error response
             */
            return $this->apiM->webservice()->response()->receive($client, $service, $request, $exception->getResponse());
        } catch (RequestException $exception) {

            /**
             * Received an error response
             */
            return $this->apiM->webservice()->response()->receive($client, $service, $request, $exception->getResponse());
        }

        /**
         * Received response
         */
        return $this->apiM->webservice()->response()->receive($client, $service, $request, $webserviceResponse);
    }
}
