<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Pimcore\ExportProductGroupBundle\Config;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Client
 *
 * @package Publikat\Pimcore\ExportProductGroupBundle\Config
 * @author  Oliver Friedrich <of@life-style.de>
 *
 * @Serializer\XmlRoot("Client")
 */
class Client
{
    /**
     * @Serializer\SerializedName("Id")
     * @Serializer\Type("string")
     * @var string
     */
    private $id;

    /**
     * @Serializer\SerializedName("Active")
     * @Serializer\Type("boolean")
     * @var boolean
     */
    private $active;

    /**
     * @Serializer\SerializedName("Services")
     * @Serializer\Type("ArrayCollection<Publikat\Pimcore\ExportProductGroupBundle\Config\Service>")
     * @Serializer\XmlList(entry="Service")
     * @var ArrayCollection
     */
    private $services;

    /**
     * @Serializer\SerializedName("Units")
     * @Serializer\Type("Publikat\Pimcore\ExportProductGroupBundle\Config\Units")
     * @var Units
     */
    private $units;

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return ArrayCollection
     */
    public function getServices()
    {
        return $this->services;
    }

    /**
     * @return Units
     */
    public function getUnits()
    {
        return $this->units;
    }

    /**
     * @return boolean
     */
    public function isActive()
    {
        return $this->active;
    }
}
