<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Pimcore\ExportProductGroupBundle\ValueMapper;

use Publikat\Pimcore\ExportProductGroupBundle\Config\Objects\Property as ConfigProperty;
use Publikat\Pimcore\ExportProductGroupBundle\Mapper\ProduktGruppe as ObjectMapper;

/**
 * Interface MapperInterface
 *
 * @package Publikat\Pimcore\ExportProductGroupBundle\ValueMapper
 * @author  Oliver Friedrich <of@life-style.de>
 */
interface MapperInterface
{
    /**
     * Get list of valid units
     *
     * @return array
     */
    public function getValidUnits();

    /**
     * Map value
     *
     * @param ObjectMapper   $objectMapper
     * @param ConfigProperty $property
     * @param string         $language
     *
     * @return mixed
     */
    public function map(ObjectMapper $objectMapper, ConfigProperty $property, $language);
}
