<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Pimcore\ExportProductGroupBundle\Webservice;

use GuzzleHttp\Exception\RequestException as WebserviceRequestException;
use Publikat\Pimcore\ExportProductGroupBundle\Api\Manager as ApiManager;
use Publikat\Pimcore\ExportProductGroupBundle\Config\Client as ClientConfig;
use Publikat\Pimcore\ExportProductGroupBundle\Config\Service as ServiceConfig;
use Publikat\Pimcore\ExportProductGroupBundle\Model\Request\RequestInterface;
use Publikat\Pimcore\ExportProductGroupBundle\Model\Response\ResponseInterface;

/**
 * Webservice-Request
 *
 * @package Publikat\Pimcore\ExportProductGroupBundle\Webservice
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Request
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @param RequestInterface $request
     * @param ClientConfig     $client
     * @param ServiceConfig    $service
     *
     * @return ResponseInterface
     * @throws \Exception
     */
    public function send(RequestInterface $request, ClientConfig $client, ServiceConfig $service)
    {
        // Prepare request
        $data = $this->apiM->serializer()->serialize($request->getRequest(), $service->getFormat());
        $options = array(
            'headers' => array(
                'Accept' => $service->getAcceptContentType(),
                'Content-Type' => $service->getContentType()
            ),
            'body' => $data
        );

        $this->apiM->logger()->info(sprintf('Object export: sending request to client "%s" url %s', $client->getId(), $service->getUrl()));
        $this->apiM->logger()->debug($options['body']);

        // Send request
        try {
            $webserviceResponse = $this->apiM->webservice()->client()->post($service->getUrl(), $options);
        } catch (WebserviceRequestException $exception) {
            // Received an error response
            return $this->apiM->webservice()->response()->receive($client, $service, $request, $exception->getResponse());
        } catch (\GuzzleHttp\Exception\ClientException $exception) {
            // Received an error response
            return $this->apiM->webservice()->response()->receive($client, $service, $request, $exception->getResponse());
        }

        if (null !== $this->apiM->muleDispatcher()) {
            $this->apiM->muleDispatcher()->dispatch($data, 'ProductGroup');
        } else {
            $this->logger->warning('Mule Message Buffer service is not available, Data is not put on the Buffer.');
        }

        // Received response
        return $this->apiM->webservice()->response()->receive($client, $service, $request, $webserviceResponse);
    }
}
