<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Pimcore\ExportProductGroupBundle\Worker;

use Publikat\Pimcore\ExportProductGroupBundle\Api\Manager as ApiManager;

/**
 * Worker-Manager
 *
 * @package Publikat\Pimcore\ExportProductGroupBundle\Worker
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Manager
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * @var array
     */
    private $factory;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * Objects delete worker
     *
     * @return Delete
     */
    public function delete()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new Delete($this->apiM));
    }

    /**
     * Objects update worker
     *
     * @return Update
     */
    public function update()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new Update($this->apiM));
    }
}
