<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Pimcore\ExportProductGroupBundle\Config\Objects;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class ArtikelFamilie
 *
 * @package Publikat\Pimcore\ExportProductGroupBundle\Config\Objects
 */
class ProduktGruppe
{

    /**
     * @Serializer\SerializedName("Property")
     * @Serializer\Type("ArrayCollection<Publikat\Pimcore\ExportProductGroupBundle\Config\Objects\Property>")
     * @Serializer\XmlList(inline=true, entry="Property")
     * @var Property[]
     */
    private $properties;

    /**
     * @return Property[]
     */
    public function getProperties()
    {
        return $this->properties;
    }
}
