<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Pimcore\ExportProductGroupBundle\Model\Response\Errors;

use JMS\Serializer\Annotation as Serializer;

/**
 *
 * @Serializer\ExclusionPolicy("all")
 *
 */
class Error
{

    /**
     * @var string
     *
     * Serializer Mapping
     * @Serializer\Expose
     * @Serializer\SerializedName("code")
     * @Serializer\Type("integer")
     */
    private $code;

    /**
     * @var string
     *
     * Serializer Mapping
     * @Serializer\Expose
     * @Serializer\SerializedName("message")
     * @Serializer\Type("string")
     */
    private $message;

    /**
     * @var string
     *
     * Serializer Mapping
     * @Serializer\Expose
     * @Serializer\SerializedName("type")
     * @Serializer\Type("string")
     */
    private $type;

    /**
     * @var string
     *
     * Serializer Mapping
     * @Serializer\Expose
     * @Serializer\SerializedName("exception")
     * @Serializer\Type("string")
     */
    private $exception;

    /**
     * @var string
     *
     * Serializer Mapping
     * @Serializer\Expose
     * @Serializer\SerializedName("debug")
     * @Serializer\Type("string")
     */
    private $debug;

    /**
     * Get code
     *
     * @return string
     */
    public function getCode()
    {

        return $this->code;
    }

    /**
     * Set code
     *
     * @param string $code
     *
     * @return Error
     */
    public function setCode($code)
    {

        $this->code = $code;

        return $this;
    }

    /**
     * Get debug
     *
     * @return string
     */
    public function getDebug()
    {

        return $this->debug;
    }

    /**
     * Set debug
     *
     * @param string $debug
     *
     * @return Error
     */
    public function setDebug($debug)
    {

        $this->debug = $debug;

        return $this;
    }

    /**
     *
     * @return string
     */
    public function getException()
    {

        return $this->exception;
    }

    /**
     *
     * @param string $exception
     */
    public function setException($exception)
    {

        $this->exception = $exception;
    }

    /**
     * Get message
     *
     * @return string
     */
    public function getMessage()
    {

        return $this->message;
    }

    /**
     * Set message
     *
     * @param string $message
     *
     * @return Error
     */
    public function setMessage($message)
    {

        $this->message = $message;

        return $this;
    }

    /**
     * Get type
     *
     * @return string
     */
    public function getType()
    {

        return $this->type;
    }

    /**
     * Set type
     *
     * @param string $type
     *
     * @return Error
     */
    public function setType($type)
    {

        $this->type = $type;

        return $this;
    }
}
