<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Pimcore\ExportProductGroupBundle\Api;

use JMS\Serializer\Serializer;
use JMS\Serializer\SerializerBuilder;
use MuleMessageBufferBundle\Service\MuleMessageBufferDispatcher;
use Pimcore\Log\ApplicationLogger;
use Publikat\Pimcore\ExportProductGroupBundle\Client\Manager as ClientManager;
use Publikat\Pimcore\ExportProductGroupBundle\Config\PluginConfig;
use Publikat\Pimcore\ExportProductGroupBundle\Mapper\Factory as MapperFactory;
use Publikat\Pimcore\ExportProductGroupBundle\Model\Manager as ModelManager;
use Publikat\Pimcore\ExportProductGroupBundle\Pimcore\Manager as PimcoreManager;
use Publikat\Pimcore\ExportProductGroupBundle\Translate\Manager as TranslateManager;
use Publikat\Pimcore\ExportProductGroupBundle\ValueMapper\Manager as ValueMapperManager;
use Publikat\Pimcore\ExportProductGroupBundle\Webservice\Manager as WebserviceManager;
use Publikat\Pimcore\ExportProductGroupBundle\Worker\Manager as WorkerManager;

/**
 * Api-Manager
 *
 * @package Publikat\Pimcore\ExportProductGroupBundle\Api
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Manager
{
    /**
     *
     * @var array
     */
    private $factory = array();

    /**
     * @var null|MuleMessageBufferDispatcher
     */
    private $muleDispatcher;

    /**
     * Manager constructor.
     *
     * @param MuleMessageBufferDispatcher|null $muleDispatcher
     */
    public function __construct(?MuleMessageBufferDispatcher $muleDispatcher)
    {
        $this->muleDispatcher = $muleDispatcher;
    }

    /**
     * @return ClientManager
     */
    public function clients()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new ClientManager($this));
    }

    /**
     * @return ApplicationLogger
     */
    public function logger()
    {
        return ApplicationLogger::getInstance("ExportProductGroup", true);
    }

    /**
     * @return MapperFactory
     */
    public function mapper()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new MapperFactory($this));
    }

    /**
     * @return ModelManager
     */
    public function model()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new ModelManager($this));
    }

    /**
     * @return PimcoreManager
     */
    public function pimcore()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new PimcoreManager($this));
    }

    /**
     * @return PluginConfig
     */
    public function pluginConfig()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = $this->serializer()->deserialize(
            file_get_contents(__DIR__ . '/../Resources/config/config.' . \Pimcore\Config::getEnvironment() . '.xml'),
            'Publikat\Pimcore\ExportProductGroupBundle\Config\PluginConfig',
            'xml'
        ));
    }

    /**
     * @return Serializer
     */
    public function serializer()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = SerializerBuilder::create()->build());
    }

    /**
     * @return TranslateManager
     */
    public function translate()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new TranslateManager($this));
    }

    /**
     * @return ValueMapperManager
     */
    public function valuemapper()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new ValueMapperManager($this));
    }

    /**
     * @return WebserviceManager
     */
    public function webservice()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new WebserviceManager($this));
    }

    /**
     * @return WorkerManager
     */
    public function worker()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new WorkerManager($this));
    }

    /**
     * @return null|MuleMessageBufferDispatcher
     */
    public function muleDispatcher()
    {
        return $this->muleDispatcher;
    }
}
