<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author    Franz Weisflug
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Pimcore\ExportProductGroupBundle\EventListener;

use Pimcore\Event\Model\ElementEventInterface;
use Pimcore\Model\Object\ProduktGruppe;
use Publikat\Pimcore\ExportProductGroupBundle\Api\Manager as ApiManager;

/**
 * Class DataObjectListener
 *
 * @package Publikat\Pimcore\ExportProductGroupBundle\EventListener
 */
class DataObjectListener
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @param ElementEventInterface $event
     *
     * @throws \Publikat\Pimcore\ExportProductGroupBundle\Config\InvalidConfigException
     * @throws \ReflectionException
     */
    public function onPostUpdate(ElementEventInterface $event)
    {
        if ($event->getElement() instanceof ProduktGruppe) {
            $this->apiM->logger()->debug('Triggered event update-object');
            $this->apiM->worker()->update()->run($event);

            if (!$event->getElement()->isPublished()) {
                $this->onPostDelete($event);
            }
        }
    }

    /**
     * @param ElementEventInterface $event
     *
     * @throws \Publikat\Pimcore\ExportProductGroupBundle\Config\InvalidConfigException
     */
    public function onPostDelete(ElementEventInterface $event)
    {
        $object = $event->getElement();
        if ($object instanceof ProduktGruppe) {
            $this->apiM->logger()->debug('Triggered event delete-object');
            $this->apiM->worker()->delete()->run($object);
        }
    }
}
