<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Pimcore\ExportProductGroupBundle\Mapper;

use Pimcore\Model\Object\Fieldcollection\Data\AbstractData as ObjectFieldcollection;
use Pimcore\Model\Object\ProduktGruppe as ObjectProduktGruppe;
use Publikat\Pimcore\ExportProductGroupBundle\Api\Manager as ApiManager;

/**
 * Factory for Mapper
 *
 * @package Publikat\Pimcore\ExportProductGroupBundle\Mapper
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Factory
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * Create new datenblatt-mapper
     *
     * @param ObjectFieldcollection $objectFieldCollection
     *
     * @return FieldCollection
     */
    public function fieldCollection(ObjectFieldcollection $objectFieldCollection)
    {
        return new FieldCollection($this->apiM, $objectFieldCollection);
    }

    /**
     * Create new article family mapper
     *
     * @param ObjectProduktGruppe $objectProduktGruppe
     *
     * @return ProduktGruppe
     */
    public function produktGruppe(ObjectProduktGruppe $objectProduktGruppe)
    {
        return new ProduktGruppe($this->apiM, $objectProduktGruppe);
    }
}
