<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace ExportProductGroup\Tests;

require_once dirname(__FILE__) . '/TestBase.php';

/**
 * Class EventListenerTest
 *
 * @package ExportProductGroup\Tests
 */
class EventListenerTest extends TestBase
{

    /**
     * @throws \Exception
     */
    public function testDelete()
    {

        $apiM = $this->webserviceBuildApiM();
        $apiM->eventListener()->delete()->init();
        $this->webserviceAddResponse(200, array('Content-Type' => 'application/json'), json_encode(array()));
        $event = new \Zend_EventManager_Event('object.postDelete', $this->getArtikelFamilieUnpublished());
        $apiM->eventListener()->delete()->delete($event);
    }

    /**
     *
     */
    public function testNotSubscibed()
    {

        $this->apiM()->eventListener()->update()->update(new \Zend_EventManager_Event('object.postUpdate'));
        $this->apiM()->eventListener()->delete()->unpublish(new \Zend_EventManager_Event('object.postUpdate'));
        $this->apiM()->eventListener()->delete()->delete(new \Zend_EventManager_Event('object.postDelete'));
    }

    /**
     * @throws \Exception
     */
    public function testUnpublish()
    {

        $apiM = $this->webserviceBuildApiM();
        $apiM->eventListener()->delete()->init();
        $this->webserviceAddResponse(200, array('Content-Type' => 'application/json'), json_encode(array()));
        $event = new \Zend_EventManager_Event('object.postUpdate', $this->getArtikelFamilieUnpublished());
        $apiM->eventListener()->delete()->unpublish($event);
    }

    /**
     * @throws \Exception
     */
    public function testUpdate()
    {

        $apiM = $this->webserviceBuildApiM();
        $apiM->eventListener()->update()->init();
        $this->webserviceAddResponse(200, array('Content-Type' => 'application/json'), json_encode(array()));
        $event = new \Zend_EventManager_Event('object.postUpdate', $this->getArtikelFamilieUnpublished());
        $apiM->eventListener()->update()->update($event);
    }
}
