<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace ExportProductGroup\Tests;

require_once dirname(__FILE__) . '/TestBase.php';

/**
 * Unit Tests
 *
 * @package ExportObjects\Tests
 * @author  Oliver Friedrich <of@life-style.de>
 */
class ManagerTest extends TestBase
{

    /**
     * Test instances
     */
    public function testApiManager()
    {

        $this->assertInstanceOf('ExportProductGroup\Client\Manager', $this->apiM()->clients());
        $this->assertInstanceOf('ExportProductGroup\Config\PluginConfig', $this->apiM()->pluginConfig());
        $this->assertInstanceOf('ExportProductGroup\EventListener\Manager', $this->apiM()->eventListener());
        $this->assertInstanceOf('ExportProductGroup\Mapper\Factory', $this->apiM()->mapper());
        $this->assertInstanceOf('ExportProductGroup\Model\Manager', $this->apiM()->model());
        $this->assertInstanceOf('ExportProductGroup\ValueMapper\Manager', $this->apiM()->valuemapper());
        $this->assertInstanceOf('ExportProductGroup\Pimcore\Manager', $this->apiM()->pimcore());
        $this->assertInstanceOf('ExportProductGroup\Translate\Manager', $this->apiM()->translate());
        $this->assertInstanceOf('ExportProductGroup\Webservice\Manager', $this->apiM()->webservice());
        $this->assertInstanceOf('ExportProductGroup\Worker\Manager', $this->apiM()->worker());
        $this->assertInstanceOf('Zend_Log', $this->apiM()->logger());
        $this->assertInstanceOf('JMS\Serializer\Serializer', $this->apiM()->serializer());
    }

    /**
     * @expectedException \ExportProductGroup\Config\InvalidConfigException
     */
    public function testClientManager()
    {

        $this->assertInstanceOf('Doctrine\Common\Collections\ArrayCollection', $this->apiM()->clients()->configured());
        $this->assertInstanceOf('Doctrine\Common\Collections\ArrayCollection', $this->apiM()->clients()->active());
        if ($this->apiM()->clients()->active()->count()) {
            $client = $this->apiM()->clients()->active()->first();
            $this->assertInstanceOf('ExportProductGroup\Config\Client', $client);
        }
        if ($this->apiM()->clients()->configured()->count()) {
            $client = $this->apiM()->clients()->configured()->first();
            $this->assertInstanceOf('ExportProductGroup\Config\Client', $client);
            $service = $this->apiM()->clients()->service($client, 'Objects::Update');
            $this->assertInstanceOf('ExportProductGroup\Config\Service', $service);
            $this->apiM()->clients()->service($client, 'UnknownController::UnknownAction');
        }
    }

    /**
     *
     */
    public function testModelManager()
    {

        $this->assertInstanceOf('ExportProductGroup\Model\Request\Objects\Delete\Factory', $this->apiM()->model()->objectsDelete());
        $this->assertInstanceOf('ExportProductGroup\Model\Request\Objects\Update\Factory', $this->apiM()->model()->objectsUpdate());
    }

    /**
     *
     */
    public function testPimcoreManager()
    {

        $this->assertInstanceOf('ExportProductGroup\Pimcore\Config', $this->apiM()->pimcore()->config());
    }

    /**
     *
     */
    public function testWebserviceManager()
    {

        $this->assertInstanceOf('ExportProductGroup\Webservice\Request', $this->apiM()->webservice()->request());
        $this->assertInstanceOf('ExportProductGroup\Webservice\Response', $this->apiM()->webservice()->response());
    }

    /**
     *
     */
    public function testWorkerManager()
    {

        $this->assertInstanceOf('ExportProductGroup\Worker\Delete', $this->apiM()->worker()->delete());
        $this->assertInstanceOf('ExportProductGroup\Worker\Update', $this->apiM()->worker()->update());
    }
}
