<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace ExportProductGroup\Api;

use ExportProductGroup\Client\Manager as ClientManager;
use ExportProductGroup\Config\PluginConfig;
use ExportProductGroup\EventListener\Manager as EventListenerManager;
use ExportProductGroup\Mapper\Factory as MapperFactory;
use ExportProductGroup\Model\Manager as ModelManager;
use ExportProductGroup\Pimcore\Manager as PimcoreManager;
use ExportProductGroup\Translate\Manager as TranslateManager;
use ExportProductGroup\ValueMapper\Manager as ValueMapperManager;
use ExportProductGroup\Webservice\Manager as WebserviceManager;
use ExportProductGroup\Worker\Manager as WorkerManager;
use JMS\Serializer\Serializer;
use JMS\Serializer\SerializerBuilder;
use Zend_Log as Logger;
use Zend_Log_Filter_Priority as LogFilter;
use Zend_Log_Writer_Stream as LogWriter;

// For the next release of PimCore
//use Pimcore\Log\Log as Logger;
//use Pimcore\Log\Writer\Stream as LogWriter;

/**
 * Api-Manager
 *
 * @package ExportProductGroup\Api
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Manager
{

    /**
     *
     * @var array
     */
    private $factory = array();

    /**
     * @return ClientManager
     */
    public function clients()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new ClientManager($this));
    }

    /**
     * @return EventListenerManager
     */
    public function eventListener()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new EventListenerManager($this));
    }

    /**
     * @return Logger
     */
    public function logger()
    {

        if (!isset($this->factory[__FUNCTION__])) {
            $logWriter = new LogWriter(PIMCORE_LOG_DIRECTORY . '/productGroup-export.log');
            $logWriter->addFilter(new LogFilter((int) max(\Logger::getPriorities())));
            $this->factory[__FUNCTION__] = new Logger($logWriter);
        }

        return $this->factory[__FUNCTION__];

        // The next release of PimCore will make it easier!
//        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new Logger(new LogWriter(PIMCORE_LOG_DIRECTORY . '/object-export.log', null, max(\Logger::getPriorities()))));
    }

    /**
     * @return MapperFactory
     */
    public function mapper()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new MapperFactory($this));
    }

    /**
     * @return ModelManager
     */
    public function model()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new ModelManager($this));
    }

    /**
     * @return PimcoreManager
     */
    public function pimcore()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new PimcoreManager($this));
    }

    /**
     * @return PluginConfig
     */
    public function pluginConfig()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = $this->serializer()->deserialize(file_get_contents(__DIR__ . '/../../../config.xml'),
            'ExportProductGroup\Config\PluginConfig', 'xml'));
    }

    /**
     * @return Serializer
     */
    public function serializer()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = SerializerBuilder::create()->build());
    }

    /**
     * @return TranslateManager
     */
    public function translate()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new TranslateManager($this));
    }

    /**
     * @return ValueMapperManager
     */
    public function valuemapper()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new ValueMapperManager($this));
    }

    /**
     * @return WebserviceManager
     */
    public function webservice()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new WebserviceManager($this));
    }

    /**
     * @return WorkerManager
     */
    public function worker()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new WorkerManager($this));
    }
}
