<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace ExportProductGroup\Client;

use Doctrine\Common\Collections\ArrayCollection;
use ExportProductGroup\Api\Manager as ApiManager;
use ExportProductGroup\Config\Client;
use ExportProductGroup\Config\InvalidConfigException;
use ExportProductGroup\Config\Service;

/**
 * Client-Manager
 *
 * @package ExportProductGroup\Client
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Manager
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {

        $this->apiM = $apiM;
    }

    /**
     * Get list of active clients
     *
     * @param string $clientId Set client-id, if list should be filtered to one client
     *
     * @return Client[]
     */
    public function active($clientId = null)
    {

        $clients = new ArrayCollection();
        foreach ($this->apiM->pluginConfig()->getClients() as $client) {
            if ($client->isActive() && (null == $clientId || $client->getId() == $clientId)) {
                $clients[] = $client;
            }
        }

        return $clients;
    }

    /**
     * Get list of configured clients
     *
     * @return Client[]
     */
    public function configured()
    {

        return $this->apiM->pluginConfig()->getClients();
    }

    /**
     * Get service from service list depending on service name
     *
     * @param Client $client
     * @param string $serviceName
     *
     * @return Service
     * @throws InvalidConfigException
     */
    public function service(Client $client, $serviceName)
    {

        foreach ($client->getServices() as $service) {
            if ($serviceName == $service->getName()) {
                return $service;
            }
        }
        throw new InvalidConfigException(sprintf('Cannot find service configuration for %s', $serviceName));
    }
}
