<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace ExportProductGroup\Config;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Config
 *
 * @package ExportProductGroup\Config
 * @author  Oliver Friedrich <of@life-style.de>
 *
 * @Serializer\XmlRoot("ExportProductGroup")
 */
class PluginConfig
{
    /**
     * @Serializer\SerializedName("Clients")
     * @Serializer\Type("ArrayCollection<ExportProductGroup\Config\Client>")
     * @Serializer\XmlList(inline = false, entry = "Client")
     * @var ArrayCollection
     */
    private $clients;

    /**
     * @Serializer\SerializedName("Objects")
     * @Serializer\Type("ExportProductGroup\Config\Objects")
     * @var Objects
     */
    private $objects;

    /**
     * @return Client[]
     */
    public function getClients()
    {

        return $this->clients;
    }

    /**
     * @return Objects
     */
    public function getObjects()
    {

        return $this->objects;
    }

}
