<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */


namespace ExportProductGroup\Config;

use ExportProductGroup\Config\Unit;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Units Configuration
 *
 * @package ExportProductGroup\Config
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Units
{
    /**
     * @Serializer\SerializedName("Area")
     * @Serializer\Type("ExportProductGroup\Config\Unit\Area")
     * @var Unit\Area
     */
    private $area;

    /**
     * @Serializer\SerializedName("Length")
     * @Serializer\Type("ExportProductGroup\Config\Unit\Length")
     * @var Unit\Length
     */
    private $length;

    /**
     * @Serializer\SerializedName("LuminousFlux")
     * @Serializer\Type("ExportProductGroup\Config\Unit\LuminousFlux")
     * @var Unit\LuminousFlux
     */
    private $luminousFlux;

    /**
     * @Serializer\SerializedName("Mass")
     * @Serializer\Type("ExportProductGroup\Config\Unit\Mass")
     * @var Unit\Mass
     */
    private $mass;

    /**
     * @Serializer\SerializedName("Power")
     * @Serializer\Type("ExportProductGroup\Config\Unit\Power")
     * @var Unit\Power
     */
    private $power;

    /**
     * @Serializer\SerializedName("Energy")
     * @Serializer\Type("ExportProductGroup\Config\Unit\Energy")
     * @var Unit\Energy
     */
    private $energy;

    /**
     * @Serializer\SerializedName("ElectricCharge")
     * @Serializer\Type("ExportProductGroup\Config\Unit\ElectricCharge")
     * @var Unit\ElectricCharge
     */
    private $electricCharge;

    /**
     * @Serializer\SerializedName("Temperature")
     * @Serializer\Type("ExportProductGroup\Config\Unit\Temperature")
     * @var Unit\Temperature
     */
    private $temperature;

    /**
     * @Serializer\SerializedName("Time")
     * @Serializer\Type("ExportProductGroup\Config\Unit\Time")
     * @var Unit\Time
     */
    private $time;

    /**
     * @Serializer\SerializedName("Voltage")
     * @Serializer\Type("ExportProductGroup\Config\Unit\Voltage")
     * @var Unit\Voltage
     */
    private $voltage;

    /**
     * @return Unit\Area
     */
    public function getArea()
    {

        return $this->area;
    }

    /**
     * @return Unit\ElectricCharge
     */
    public function getElectricCharge()
    {

        return $this->electricCharge;
    }

    /**
     * @return Unit\Energy
     */
    public function getEnergy()
    {

        return $this->energy;
    }

    /**
     * @return Unit\Length
     */
    public function getLength()
    {

        return $this->length;
    }

    /**
     * @return Unit\LuminousFlux
     */
    public function getLuminousFlux()
    {

        return $this->luminousFlux;
    }

    /**
     * @return Unit\Mass
     */
    public function getMass()
    {

        return $this->mass;
    }

    /**
     * @return Unit\Power
     */
    public function getPower()
    {

        return $this->power;
    }

    /**
     * @return Unit\Temperature
     */
    public function getTemperature()
    {

        return $this->temperature;
    }

    /**
     * @return Unit\Time
     */
    public function getTime()
    {

        return $this->time;
    }

    /**
     * @return Unit\Voltage
     */
    public function getVoltage()
    {

        return $this->voltage;
    }

}
