<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace ExportProductGroup\EventListener;

use ExportProductGroup\Api\Manager as ApiManager;
use Pimcore\Model\Object\ProduktGruppe;

/**
 * Event-Listener Update-Object
 *
 * @package ExportProductGroup
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Update implements ListenerInterface
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {

        $this->apiM = $apiM;
    }

    /**
     * Attach event listener
     */
    public function init()
    {

        \Pimcore::getEventManager()->attach("object.postUpdate", array($this, 'update'));
    }

    /**
     * @param \Zend_EventManager_Event $event
     *
     * @return \Zend_EventManager_Event
     * @throws \ExportProductGroup\Config\InvalidConfigException
     */
    public function update(\Zend_EventManager_Event $event)
    {

        if ($this->hasSubscribed($event)) {
            $this->apiM->logger()->debug('Triggered event update-object');
            $this->apiM->worker()->update()->run($event);
        }

        return $event;
    }

    /**
     * @param \Zend_EventManager_Event $event
     *
     * @return bool
     */
    private function hasSubscribed(\Zend_EventManager_Event $event)
    {

        return $event->getTarget() instanceof ProduktGruppe;
    }
}
