<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace ExportProductGroup\Mapper;

use ReflectionClass;

/**
 * Base Mapper for Object- and Fieldcollection-Mapper
 *
 * @package ExportProductGroup\Mapper
 * @author  Oliver Friedrich <of@life-style.de>
 */
abstract class Base
{
    /**
     * @param string $property
     *
     * @return boolean
     */
    abstract protected function filterProperties($property);

    /**
     * @return array
     */
    public function getObjectProperties()
    {

        $reflectionClass = new ReflectionClass(get_class($this->getObject()));
        $properties = $reflectionClass->getProperties();
        array_walk($properties, function (&$property) {

            $property = $property->getName();
        });

        return array_filter($properties, array($this, 'filterProperties'));
    }

    /**
     * @return object
     */
    abstract public function getObject();
}
