<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace ExportProductGroup\Mapper;

use ExportProductGroup\Api\Manager as ApiManager;
use Pimcore\Model\Object\AbstractObject;
use Pimcore\Model\Object\Fieldcollection\Data\AbstractData as ObjectFieldcollection;

/**
 * Field-Collection-Mapper
 *
 * @package ExportProductGroup\Mapper
 * @author  Oliver Friedrich <of@life-style.de>
 */
class FieldCollection extends Base
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * @var ObjectFieldcollection
     */
    protected $fieldCollection;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM, ObjectFieldcollection $objectFieldcollection)
    {

        $this->apiM = $apiM;
        $this->fieldCollection = $objectFieldcollection;
    }

    /**
     * @param string $property
     *
     * @return boolean
     */
    protected function filterProperties($property)
    {

        return (boolean) preg_match('/^datenblatt(Multi)?[A-Z]/', $property);
    }

    /**
     * @return array
     */
    public function getValues()
    {

        $values = array();
        foreach ($this->getObjectProperties() as $property) {
            $method = 'get' . ucfirst($property);
            null !== ($value = $this->getObject()->$method()) ? $values[$property] = $value : null;
        }

        return $values;
    }

    /**
     * @return ObjectFieldcollection
     */
    public function getObject()
    {

        return $this->fieldCollection;
    }
}
