<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace ExportProductGroup\Mapper;

use ExportProductGroup\Api\Manager as ApiManager;
use Pimcore\Model\Object\AbstractObject;
use Pimcore\Model\Object\ProduktGruppe as ObjectProduktGruppe;

/**
 * Class ArtikelFamilie
 *
 * @package ExportProductGroup\Mapper
 */
class ProduktGruppe extends Object
{

    /**
     * @var ObjectProduktGruppe
     */
    private $objectProduktGruppe;

    /**
     * ArtikelFamilie constructor.
     *
     * @param ApiManager          $apiM
     * @param ObjectProduktGruppe $objectProduktGruppe
     */
    public function __construct(ApiManager $apiM, ObjectProduktGruppe $objectProduktGruppe)
    {

        parent::__construct($apiM);
        $this->objectProduktGruppe = $objectProduktGruppe;
    }

    /**
     * @param string $property
     *
     * @return boolean
     */
    protected function filterProperties($property)
    {

        return preg_match('/^ProduktGruppe/', $property) || 'localizedfields' == $property;
    }

    /**
     * @return ObjectProduktGruppe
     */
    public function getObject()
    {

        return $this->objectProduktGruppe;
    }

    /**
     * Map name to name-id
     *
     * @param $name
     *
     * @return mixed
     */
    public function mapNameId($name)
    {

        return preg_replace('/^ProduktGruppe(multi)?/i', '', $name);
    }
}
