<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace ExportProductGroup\Model;

use ExportProductGroup\Api\Manager as ApiManager;
use ExportProductGroup\Model\Credentials\Factory as CredentialsFactory;
use ExportProductGroup\Model\Request\Objects\Delete\Factory as ObjectsDeleteFactory;
use ExportProductGroup\Model\Request\Objects\Update\Factory as ObjectsUpdateFactory;

/**
 * Model-Manager
 *
 * @package ExportProductGroup\Model
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Manager
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * @var array
     */
    private $factory;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {

        $this->apiM = $apiM;
    }

    /**
     * @return ObjectsDeleteFactory
     */
    public function objectsDelete()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new ObjectsDeleteFactory($this->apiM));
    }

    /**
     * @return ObjectsUpdateFactory
     */
    public function objectsUpdate()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new ObjectsUpdateFactory($this->apiM));
    }
}
