<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace ExportProductGroup\Model\Request\Objects\Update;

use ExportProductGroup\Api\Manager as ApiManager;

/**
 * Objects Update Factory
 *
 * @package ExportProductGroup\Model\Request\Objects\Update
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Factory
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {

        $this->apiM = $apiM;
    }

    /**
     * Create new item
     *
     * @param Request $request
     *
     * @return Item
     */
    public function item(Request $request)
    {

        $item = new Item();
        $request->addItem($item);

        return $item;
    }

    /**
     * Create new name-field-list
     *
     * @param Item $item
     *
     * @return NameFieldList
     */
    public function nameFieldList(Item $item)
    {

        $nameFieldList = new NameFieldList();
        $item->addDocumentField($nameFieldList);

        return $nameFieldList;
    }

    /**
     * Create new request
     *
     * @return Request
     */
    public function request()
    {

        return new Request();
    }

    /**
     * Create new value item
     *
     * @param NameFieldList $nameFieldList
     *
     * @return ValueItem
     */
    public function valueItem(NameFieldList $nameFieldList)
    {

        $valueItem = new ValueItem();
        $nameFieldList->addValueItem($valueItem);

        return $valueItem;
    }
}
