<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace ExportProductGroup\Model\Request\Objects\Update;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Request-Node
 *
 * @package ExportProductGroup\Model\Request\Objects\Update
 * @author  Oliver Friedrich <of@life-style.de>
 *
 * @Serializer\XmlRoot("Item")
 */
class Item
{

    /**
     * @Serializer\SerializedName("ProductId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $productId = '';

    /**
     * @Serializer\SerializedName("ProductTitle")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $productTitle;

    /**
     * @Serializer\SerializedName("DocumentLanuages")
     * @Serializer\Type("array<string>")
     * @Serializer\XmlList(entry="Value")
     *
     * @var array
     */
    private $documentLanguages = array();

    /**
     * @Serializer\SerializedName("DocumentFields")
     * @Serializer\Type("ArrayCollection<ExportProductGroup\Model\Request\Objects\Update\NameFieldList>")
     * @Serializer\XmlList(entry="NameFieldList")
     *
     * @var NameFieldList[]
     */
    private $documentFields;

    /**
     * Item constructor.
     */
    public function __construct()
    {

        $this->documentFields = new ArrayCollection();
    }

    /**
     * Add value item
     *
     * @param NameFieldList $value
     *
     * @return Item
     */
    public function addDocumentField(NameFieldList $value)
    {

        $this->documentFields[] = $value;

        return $this;
    }

    /**
     * Add document language
     *
     * @param string $value
     *
     * @return Item
     */
    public function addDocumentLanguage($value)
    {

        $this->documentLanguages[] = (string) $value;

        return $this;
    }

    /**
     * Delete empty DocumentFields array
     *
     * @Serializer\PreSerialize
     */
    public function nullDocumentFields()
    {

        if (!count($this->documentFields)) {
            $this->documentFields = null;
        }
    }

    /**
     * Set ProductId
     *
     * @param string $productId
     *
     * @return Item
     */
    public function setProductId($productId)
    {

        $this->productId = (string) $productId;

        return $this;
    }

    /**
     * Set ProductTitle
     *
     * @param string $productTitle
     *
     * @return Item
     */
    public function setProductTitle($productTitle)
    {

        $this->productTitle = (string) $productTitle;

        return $this;
    }

}
