<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace ExportProductGroup\Model\Request\Objects\Update;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Request-Node
 *
 * @package ExportProductGroup\Model\Request\Objects\Update
 * @author  Oliver Friedrich <of@life-style.de>
 *
 * @Serializer\XmlRoot("NameFieldList")
 */
class NameFieldList
{

    /**
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("Language")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $language;

    /**
     * @Serializer\SerializedName("labelId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $labelId;

    /**
     * @Serializer\SerializedName("Label")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $label;

    /**
     * @Serializer\SerializedName("ValueId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $valueId;

    /**
     * @Serializer\SerializedName("Value")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $value;

    /**
     * @Serializer\SerializedName("ValueClean")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $valueClean;

    /**
     * @Serializer\SerializedName("Meta")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $meta;

    /**
     * @Serializer\SerializedName("ShopGroup")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $shopGroup;

    /**
     * @Serializer\SerializedName("Values")
     * @Serializer\Type("ArrayCollection<ExportProductGroup\Model\Request\Objects\Update\ValueItem>")
     * @Serializer\XmlList(entry="ValueItem")
     *
     * @var \ExportProductGroup\Model\Request\Objects\Update\ValueItem[]
     */
    private $values;

    /**
     * NameFieldList constructor.
     */
    public function __construct()
    {

        $this->values = new ArrayCollection();
    }

    /**
     * Add value item
     *
     * @param ValueItem $value
     *
     * @return NameFieldList
     */
    public function addValueItem(ValueItem $value)
    {

        $this->values[] = $value;

        return $this;
    }

    /**
     * Delete empty Value items array
     *
     * @Serializer\PreSerialize
     */
    public function nullValuesFields()
    {

        // Don't use multiple and single values at the same time!
        if (!count($this->values)) {
            $this->values = null;
        } else {
            $this->valueId = null;
            $this->value = null;
            $this->meta = null;
        }
    }

    /**
     * @param string $label
     *
     * @return NameFieldList
     */
    public function setLabel($label)
    {

        $this->label = (string) $label;

        return $this;
    }

    /**
     * @param string $labelId
     *
     * @return NameFieldList
     */
    public function setLabelId($labelId)
    {

        $this->labelId = (string) $labelId;

        return $this;
    }

    /**
     * @param string $language
     *
     * @return NameFieldList
     */
    public function setLanguage($language)
    {

        $this->language = (string) $language;

        return $this;
    }

    /**
     * @param string $meta
     *
     * @return NameFieldList
     */
    public function setMeta($meta)
    {

        $this->meta = (string) $meta;

        return $this;
    }

    /**
     * @param string $name
     *
     * @return NameFieldList
     */
    public function setName($name)
    {

        $this->name = (string) $name;

        return $this;
    }

    /**
     * @param string $shopGroup
     *
     * @return NameFieldList
     */
    public function setShopGroup($shopGroup)
    {

        $this->shopGroup = $shopGroup;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return NameFieldList
     */
    public function setValue($value)
    {

        $this->value = trim((string) $value);

        return $this;
    }

    /**
     * @param string $valueClean
     *
     * @return NameFieldList
     */
    public function setValueClean($valueClean)
    {

        $this->valueClean = (string) $valueClean;

        return $this;
    }

    /**
     * @param string $valueId
     *
     * @return NameFieldList
     */
    public function setValueId($valueId)
    {

        $this->valueId = (string) $valueId;

        return $this;
    }
}
