<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace ExportProductGroup\Model\Request\Objects\Update;

use JMS\Serializer\Annotation as Serializer;

/**
 * Request-Node
 *
 * @package ExportProductGroup\Model\Request\Objects\Update
 * @author  Oliver Friedrich <of@life-style.de>
 *
 * @Serializer\XmlRoot("ValueItem")
 */
class ValueItem
{

    /**
     * @Serializer\SerializedName("ValueId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $valueId;

    /**
     * @Serializer\SerializedName("Value")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $value;

    /**
     * @Serializer\SerializedName("ValueClean")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $valueClean;

    /**
     * @Serializer\SerializedName("Meta")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $meta;

    /**
     * Set Meta
     *
     * @param string $meta
     *
     * @return ValueItem
     */
    public function setMeta($meta)
    {

        $this->meta = (string) $meta;

        return $this;
    }

    /**
     * Set Value
     *
     * @param string $value
     *
     * @return ValueItem
     */
    public function setValue($value)
    {

        $this->value = (string) $value;

        return $this;
    }

    /**
     * Set ValueClean
     *
     * @param string $valueClean
     *
     * @return ValueItem
     */
    public function setValueClean($valueClean)
    {

        $this->valueClean = (string) $valueClean;

        return $this;
    }

    /**
     * Set Value-ID
     *
     * @param string $valueId
     *
     * @return ValueItem
     */
    public function setValueId($valueId)
    {

        $this->valueId = $valueId;

        return $this;
    }

}
