<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace ExportProductGroup\Pimcore;

use ExportProductGroup\Api\Manager as ApiManager;
use Pimcore\Config as PimcoreConfig;

/**
 * Pimcore Configuration
 *
 * @package ExportProductGroup\Pimcore
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Config
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {

        $this->apiM = $apiM;
    }

    /**
     * Get default language
     *
     * @return string
     */
    public function getDefaultLanguage()
    {

        return empty(PimcoreConfig::getSystemConfig()->general->defaultLanguage) ?
            'en' :
            PimcoreConfig::getSystemConfig()->general->defaultLanguage;
    }

    /**
     * Get list of fallback-languages
     *
     * @param string $language
     *
     * @return array
     */
    public function getFallbackLanguages($language)
    {

        return isset(PimcoreConfig::getSystemConfig()->general->fallbackLanguages->{$language}) ?
            explode(',', str_replace(' ', '', PimcoreConfig::getSystemConfig()->general->fallbackLanguages->{$language})) :
            array();
    }

    /**
     * Get list of available languages
     *
     * @return array
     */
    public function getLanguages()
    {

        return isset(PimcoreConfig::getSystemConfig()->general->validLanguages) ?
            explode(',', str_replace(' ', '', PimcoreConfig::getSystemConfig()->general->validLanguages)) :
            array();
    }

    /**
     * Returns true, if debug mode is on
     *
     * @return bool
     */
    public function isDebugMode()
    {

        return isset(PimcoreConfig::getSystemConfig()->general->debug) && PimcoreConfig::getSystemConfig()->general->debug;
    }
}
