<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace ExportProductGroup;

use Doctrine\Common\Annotations\AnnotationRegistry;
use ExportProductGroup\Api\Manager as ApiManager;
use Pimcore\API\Plugin as PluginLib;
use Symfony\Component\VarDumper\Cloner\VarCloner;
use Symfony\Component\VarDumper\Dumper\CliDumper;
use Symfony\Component\VarDumper\VarDumper;

/**
 * Class Plugin
 *
 * @package ExportProductGroup
 */
class Plugin extends PluginLib\AbstractPlugin implements PluginLib\PluginInterface
{

    /**
     * @param string $language
     *
     * @return null|string
     */
    public static function getTranslationFile($language)
    {

        return null;
    }

    /**
     * Init plugin
     */
    public function init()
    {

        // Annotation class loader needs this
        AnnotationRegistry::registerLoader('class_exists');

        $apiM = new ApiManager();
        $apiM->eventListener()->init();

        $this->initDump($apiM);
    }

    /**
     * @param ApiManager $apiM
     */
    private function initDump(ApiManager $apiM)
    {

        $logger = $apiM->logger();
        VarDumper::setHandler(function ($var) use ($logger) {

            $cloner = new VarCloner();
            $dumper = new CliDumper();
            $output = fopen('php://memory', 'r+b');

            $dumper->dump($cloner->cloneVar($var), $output);
            $logger->debug(stream_get_contents($output, -1, 0));
        });
    }

    /**
     * @return string
     */
    public static function install()
    {

        $path = self::getInstallPath();

        if (!is_dir($path)) {
            mkdir($path);
        }

        if (self::isInstalled()) {
            return "ExportProductGroup Plugin successfully installed.";
        } else {
            return "ExportProductGroup Plugin could not be installed.";
        }
    }

    /**
     * @return string
     */
    public static function getInstallPath()
    {

        return PIMCORE_PLUGINS_PATH . "/ExportProductGroup/install";
    }

    /**
     * @return bool
     */
    public static function isInstalled()
    {

        return is_dir(self::getInstallPath());
    }

    /**
     * @return bool
     */
    public static function needsReloadAfterInstall()
    {

        return false;
    }

    /**
     * @return string
     */
    public static function uninstall()
    {

        rmdir(self::getInstallPath());

        if (!self::isInstalled()) {
            return "ExportProductGroup Plugin successfully uninstalled.";
        } else {
            return "ExportProductGroup Plugin could not be uninstalled.";
        }
    }

}
