<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace ExportProductGroup\Worker;

use ExportProductGroup\Api\Manager as ApiManager;
use ExportProductGroup\Model\Request\Objects\Delete\Request;
use Pimcore\Model\Object\ProduktGruppe;

/**
 * Delete Worker
 *
 * @package ExportProductGroup\Worker
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Delete
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {

        $this->apiM = $apiM;
    }

    /**
     * Run export
     *
     * @param ProduktGruppe $object
     */
    public function run(ProduktGruppe $object)
    {

        // Prepare request
        $modelRequest = $this->apiM->model()->objectsDelete()->request();

        // Prepare data
        $this->delete($modelRequest, $object);

        $this->apiM->logger()->debug(sprintf('Object "%s" (ID: %d) added to delete request',
            $object->getKey(),
            $object->getId()));

        // Send request
        foreach ($this->apiM->clients()->active() as $client) {
            $service = $this->apiM->clients()->service($client, 'Objects::Delete');
            $this->apiM->webservice()->request()->send($modelRequest, $client, $service);
        }
    }

    /**
     * @param Request       $request
     * @param ProduktGruppe $object
     */
    private function delete(Request $request, ProduktGruppe $object)
    {

        $item = $this->apiM->model()->objectsDelete()->item($request);
        $item->setProductId($object->getKey());
    }
}
