<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Pimcore\ExportProductGroupBundle\Model\Request\Objects\Update;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;
use Publikat\Pimcore\ExportProductGroupBundle\Model\Request\RequestInterface;

/**
 * Objects Update Request
 *
 * @package Publikat\Pimcore\ExportProductGroupBundle\Model\Request\Objects\Update
 * @author  Oliver Friedrich <of@life-style.de>
 *
 * @Serializer\XmlRoot("StylefileProductRequest")
 */
class Request implements RequestInterface
{

    /**
     * @Serializer\SerializedName("Item")
     * @Serializer\Type("ArrayCollection<Publikat\Pimcore\ExportProductGroupBundle\Model\Request\Objects\Update\Item>")
     * @Serializer\XmlList(inline=true, entry="Item")
     * @var Item[]
     */
    private $items;

    /**
     * Request constructor.
     */
    public function __construct()
    {
        $this->items = new ArrayCollection();
    }

    /**
     * Add item to list
     *
     * @param Item $item
     *
     * @return Request
     */
    public function addItem(Item $item)
    {
        $this->items[] = $item;

        return $this;
    }

    /**
     * @return $this
     */
    public function getRequest()
    {
        return $this;
    }

    /**
     * @return string
     */
    public function getResponseType()
    {
        return 'Publikat\Pimcore\ExportProductGroupBundle\Model\Response\Objects\Update\Response';
    }

    /**
     * Delete empty items array
     *
     * @Serializer\PreSerialize
     */
    public function nullItems()
    {
        if (is_countable($this->items) && !count($this->items)) {
            $this->items = null;
        }
    }
}
