<?php

namespace Export2Swoox\Webservice;

use Pimcore\ExtensionManager;

/**
 * Class Config
 *
 * @package Export2Swoox\Webservice
 */
class Config
{
    /**
     * @var string
     */
    private $clientId;

    /**
     * @var string
     */
    private $name;

    /**
     * @var string
     */
    private $updateUrl;

    /**
     * @var string
     */
    private $deleteUrl;

    /**
     * @var string xml|json
     */
    private $format;

    /**
     * @var string text/xml|application/json
     */
    private $contentType;

    function __construct()
    {
        $config = new \Zend_Config_Xml(PIMCORE_WEBSITE_PATH . ExtensionManager::getPluginConfig('Export2Swoox')['plugin']['pluginXmlEditorFile']);

        $baseUrl = trim($config['plugin']['export2swoox']['swoox']['baseurl']);

        $this->clientId = trim($config['plugin']['export2swoox']['swoox']['client']);
        $this->multiClientId = $config['plugin']['export2swoox']['swoox']['client-multi'];
        $this->format = 'json';
        $this->contentType = 'application/json';
        $this->updateUrl = "$baseUrl/api/v1/index/swoox.json";
        $this->deleteUrl = "$baseUrl/api/v1/delete/swoox.json";
    }

    /**
     * @return string
     */
    public function getClientId($multi = '')
    {
        if ($multi && $this->multiClientId[$multi]) {
            return trim($this->multiClientId[$multi]);
        } else {
            return $this->clientId;
        }

    }

    /**
     * @return string
     */
    public function getAcceptContentType()
    {
        return preg_replace('/;.+/', '', $this->getContentType());
    }

    /**
     * @return string
     */
    public function getContentType()
    {
        if (preg_match('/\.(xml|json)$/', $this->updateUrl, $matches)) {
            return 'xml' == $matches[1] ? 'text/xml; charset=UTF-8' : 'application/json; charset=UTF-8';
        }

        return $this->contentType;
    }

    /**
     * @return string
     */
    public function getFormat()
    {
        return preg_match('/\.(xml|json)$/', $this->updateUrl, $matches) ? $matches[1] : $this->format;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getUpdateUrl()
    {
        return $this->updateUrl;
    }

    /**
     * @return string
     */
    public function getDeleteUrl()
    {
        return $this->deleteUrl;
    }

}
