<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Export2Swoox\Webservice;

use Export2Swoox\Mapper\MapperInterface;
use GuzzleHttp\Client;
use JMS\Serializer\SerializerBuilder;
use Pimcore\Log\ApplicationLogger;
use Pimcore\View;
use Swoox\Api\Api\Manager;
use Swoox\Api\Model\Request\Search\Interfaces\RequestModelInterface;

/**
 * Webservice-Request
 *
 * todo: split in two instances and get rid of if / else of indextype
 * @package SwooxModel\Webservice
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Request
{

    /**
     * @param      $mapper MapperInterface
     * @param bool $indexRequest
     */
    public function prepareAndSend($mapper, $indexRequest)
    {
        $config = new Config();
        $payload = $mapper->getPayload();


        //je nachdem, ob Items in unterschiedliche Swoox-Clients verteilt werden sollen...
        if ($mapper->isMultiClientConfigured()) {
            foreach ($payload as $key => $items) {
                $request = $this->addItemsToSwooxRequest($items, $indexRequest);
                $client = $config->getClientId($key);
                if ($client) {
                    //Falls kein Client für jeweiliges Land konfiguriert ist -> Skip
                    $this->send($request, $config->getClientId(), $config, $indexRequest);
                }
            }
        } else {
            $request = $this->addItemsToSwooxRequest($payload, $indexRequest);
            $this->send($request, $config->getClientId(), $config, $indexRequest);
        }
    }

    private function send($request, $clientId, $config, $indexRequest)
    {

        $serializer = SerializerBuilder::create()->build();

        $options = [
            'headers' => [
                'Accept' => $config->getAcceptContentType(),
                'Content-Type' => $config->getContentType(),
                'clientid' => $clientId
            ],
            'body' => $serializer->serialize($request, $config->getFormat())
        ];

        $client = new Client();
        if ($indexRequest) {
            $webserviceResponse = $client->put($config->getUpdateUrl(), $options);
        } else {
            $webserviceResponse = $client->delete($config->getDeleteUrl(), $options);
        }

        // TODO Swoox always returns a 200 status code, even if the request wasn't successful. We need to examin the
        // response closer to determine if the request was a success or not

        $logger = ApplicationLogger::getInstance("Export2Swoox", true);
        $logger->setComponent('REQUEST');
        $logger->info((string)$webserviceResponse->getBody() . $options['body']);
        //Wenn wenn es kracht, soll der Fehler ruhig ans Frontend
    }

    /**
     * @param $swooxModelManager
     * @param $payload
     * @return mixed
     */
    private function addItemsToSwooxRequest($payload, $indexRequest)
    {
        $swooxModelManager = new Manager();

        if ($indexRequest) {
            $request = $swooxModelManager->model()->request()->index()->swoox();
        } else {
            $request = $swooxModelManager->model()->request()->delete()->swoox();
        }

        foreach ($payload as $items) {
            $request->addItem($items);
        }
        return $request;
    }


}
