<?php

namespace Export2Swoox\Worker;

use Export2Swoox\Mapper\MapperInterface;
use Export2Swoox\Webservice\Request;
use Pimcore\ExtensionManager;

abstract class AbstractWorker
{
    /**
     * @param \Zend_EventManager_Event $event
     */
    function updateSwoox($event, $index = true)
    {
        $config = ExtensionManager::getPluginConfig('Export2Swoox');

        $object = $event->getTarget();

        /**
         * @var $mapper MapperInterface
         */
        $mapper = null;
        $className = 'Export2Swoox\\Mapper\\' . $config['plugin']['export2swoox']['namespace'] . '\\' . $object->getClassName() . 'Mapper';
        $fileToInclude = __DIR__ . '/../Mapper/' . $config['plugin']['export2swoox']['namespace'] . '/' . $object->getClassName() . 'Mapper' . '.php';
        //Hätte gern nur class_exist einfach verwendet. Funktioniert auch aber intern wirft er im Nachgang der Pluginverarbeitung ein Fehler sofern die Klasse doch nicht existierte.
        if (file_exists($fileToInclude) && class_exists($className)) {
            //Klasse gibt es ...also darf auch etwas passieren
            //Neues Mapper Object erzeugen
            $mapper = new $className; //Nicht schön, aber...
            $eventWhitelist = $mapper->getEventWhitelist();
            if (in_array($event->getName(), $eventWhitelist)) {
                $mapper->generateOutput($object, $index, $event);
            }
        }

        if ($mapper && sizeof($mapper->getPayload()) > 0) {
            //ab damit nach Swoox
            (new Request())->prepareAndSend($mapper, $index);
        }
    }

}
