<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Export2Swoox\Tests;

use Export2Swoox\Plugin;

/**
 * Test plugin.php
 *
 * @package ExportTranslations
 */
class EventTest extends \PHPUnit_Framework_TestCase
{

    /**
     *  Ich bekomme ein Event, dass etwas gespeichert/gelöscht wurde
     *  -> Update/delete an Swoox reichen
     *  -> eventuell Fehler werfen
     */
    public function testEventSubscribtion()
    {
        $plugin = new Plugin();
        $plugin->init();
        $this->assertNotNull($plugin);


        $eventManager = $plugin->getEventManager();
        $this->assertTrue($eventManager->isAttached('object.postAdd'));
        $this->assertTrue($eventManager->isAttached('object.postUpdate'));
        $this->assertTrue($eventManager->isAttached('object.preDelete'));
        $this->assertFalse($eventManager->isAttached('object.xyz'));
    }

    /**
     * Event wird erzeugt und konsumiert
     */
    public function testEventHandler()
    {
        $plugin = new Plugin();
        $plugin->init();

        $em = $plugin->getEventManager();
        $this->assertEquals(0, $em->getHandledEventCount());

        //Event erzeugen
        $location = new \Pimcore\Model\Object\Location();

        $location->setLocation3lc('pmi');

        $event = new \Zend_EventManager_Event('object.postUpdate', $location);
        $pem = \Pimcore::getEventManager();
        $pem->trigger($event);

        $this->assertEquals($event, $plugin->getEventManager()->getLastEvent());
        $this->assertEquals(1, $em->getHandledEventCount());
    }


}
