<?php
/**
 * Short description for file
 *
 * Long description for file (if any)...
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       www.life-style.de
 */

namespace Publikat\Pimcore\ExportToSwooxBundle\Mapper;

use Pimcore\Model\Object\Extra;
use Swoox\Api\Api\Manager;
use Swoox\Api\Model\Request\Delete\Swoox\Item as DeleteItem;
use Swoox\Api\Model\Request\Index\Swoox\Item as IndexItem;


class ExtraMapper implements MapperInterface
{

    private $languagesToExport = ['de', 'en'];

    /**
     * @param      $extra Extra
     * @param bool $index
     *
     * @return array
     */
    public function generateOutput($extra, $index)
    {
        $items = [];
        $manager = new Manager();

        foreach ($this->languagesToExport as $language) {
//            $localizedExtra = $extra->getLocalizedfields();
//            $extraName = $localizedExtra->getLocalizedValue('extraName', $language);
//            $extraInfo = $localizedExtra->getLocalizedValue('extraInfo', $language);
//            $extraDescription = $localizedExtra->getLocalizedValue('extraDescription', $language);
            $objectId = 'extra-' . $language . '-' . $extra->getId();


//            foreach ($extra->getExtraTransfertypeZone()->getItems() as $extraTransfertypeZoneItem) {
//                $extraCosts = $extraTransfertypeZoneItem->getExtraUpgradePrice();
            $extraTransferType = [];
            $extraAgencies = [];
            foreach ($extra->getExtraMapping() as $extraMappingItems) {
                switch ($extraMappingItems->getClassName()) {
                    case 'Transferart':
                        $extraTransferType[] = $extraMappingItems->getTransfertypeId();
                        break;
                    case 'Agentur':
                        $extraAgencies[] = $extraMappingItems->getAgencyId();
                        break;
                    default:
                }
            }

            if ($index) {
                $item = new IndexItem();
                $item->setDocumentLanguage($language);
                $item->setDocumentUniqueKey($objectId);
                $item->setDocumentTitle('');
                $item->setDocumentPrefix(1);
                $item->setDocumentURL('');
                $item->setDocumentRanking(1);
                $item->addDocumentFields($manager->model()->request()->index()->nameFieldList()->setName('OBJECT_TYPE')->setValue('EXTRA'));
                $item->addDocumentFields($manager->model()->request()->index()->nameFieldList()->setName('OBJECT_ID')->setValue($objectId));
                $item->addDocumentFields($manager->model()->request()->index()->nameFieldList()->setName('LANG')->setValue($language));
                $item->addDocumentFields($manager->model()->request()->index()->nameFieldList()->setName('LANG')->setValue($language));
                $item->addDocumentFields($manager->model()->request()->index()->nameFieldList()->setName('EXTRA_ID')->setValue($extra->getId()));
                $item->addDocumentFields($manager->model()->request()->index()->nameFieldList()->setName('EXTRA_TRANSFER_PRICE')->setValue($extra->getId()));
            } else {
                $item = new DeleteItem();
                $item->setDocumentUniqueKey($objectId);
            }
            $items[] = $item;
//            }
        }

        return $items;
    }
}
