<?php
/**
 * Short description for file
 *
 * Long description for file (if any)...
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       www.life-style.de
 */

namespace Publikat\Pimcore\ExportToSwooxBundle\Mapper;

use Pimcore\Model\Object\Route;
use Swoox\Api\Api\Manager;
use Swoox\Api\Model\Request\Delete\Swoox\Item as DeleteItem;
use Swoox\Api\Model\Request\Index\Swoox\Item as IndexItem;

/**
 * Class RouteMapper
 *
 * @package Publikat\Pimcore\ExportToSwooxBundle\Mapper
 */
class RouteMapper implements MapperInterface
{

    /**
     * @param      $route Route
     * @param bool $index
     *
     * @return array
     */
    public function generateOutput($route, $index)
    {
        $items = [];
        $manager = new Manager();
        $objectId = 'route-' . $route->getId();

        $startZone = $route->getTransferrouteOrigin()[0];
        $destinationZone = $route->getTransferrouteDestination()[0];
        $agency = $route->getTransferrouteAgency()[0];
        $currency = $route->getTransferrouteCurrency()[0];

        if (!$startZone || !$destinationZone || !$agency || !$currency) {
            //Nur Objekt übertragen, wenn alle Werte gesetzt sind
            return [];
        }

        if ($index) {
            $item = new IndexItem();
            $item->setDocumentUniqueKey($objectId);
            $item->setDocumentTitle($startZone->getZoneName() . ' - ' . $destinationZone->getZoneName());
            $item->setDocumentPrefix(1);
            $item->setDocumentURL('');
            $item->setDocumentRanking(1);
            $item->addDocumentFields($manager->model()->request()->index()->nameFieldList()->setName('OBJECT_TYPE')->setValue('ROUTE'));
            $item->addDocumentFields($manager->model()->request()->index()->nameFieldList()->setName('OBJECT_ID')->setValue($route->getId()));
            $route_start = $manager->model()->request()->index()->valueItem();
            $route_start->setValue($startZone->getId());
            $route_destination = $manager->model()->request()->index()->valueItem();
            $route_destination->setValue($destinationZone->getId());
            $route_zones = $manager->model()->request()->index()->nameFieldList()->setName('ROUTE_ZONES');
            $route_zones->addValues($route_start);
            $route_zones->addValues($route_destination);
            $item->addDocumentFields($route_zones);
            $item->addDocumentFields($manager->model()->request()->index()->nameFieldList()->setName('ROUTE_AGENCY')->setValue($agency->getId()));
            $item->addDocumentFields($manager->model()->request()->index()->nameFieldList()->setName('ROUTE_CURRENCY')->setValue($currency->getCurrencyName()));
            $item->addDocumentFields($manager->model()->request()->index()->nameFieldList()->setName('ROUTE_ACTIVE')->setValue($route->getTransferrouteActive()));
            $item->addDocumentFields($manager->model()->request()->index()->nameFieldList()->setName('PUBLISHED')->setValue($route->isPublished()));

        } else {
            $item = new DeleteItem();
            $item->setDocumentUniqueKey($objectId);
        }
        $items[] = $item;

        return $items;
    }
}
