<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @author    Jochen Califice <info@life-style.de>
 * @link      www.life-style.de
 */

namespace Publikat\Pimcore\ExportToSwooxBundle\EventListener;

use Pimcore\Event\Model\ElementEventInterface;
use Pimcore\Event\Model\DataObjectEvent;
use Publikat\Pimcore\ExportToSwooxBundle\Worker\Update as UpdateWorker;

/**
 * Class DataObjectListener
 *
 * @package Publikat\Pimcore\ExportToSwooxBundle\EventListener
 */
class DataObjectListener
{
    /**
     * @var UpdateWorker
     */
    protected $updateWorker;

    /**
     * DataObjectListener constructor.
     *
     * @param UpdateWorker $updateWorker
     */
    public function __construct(UpdateWorker $updateWorker)
    {
        $this->updateWorker = $updateWorker;
    }

    /**
     * @param ElementEventInterface $event
     * @param string                $eventName
     *
     * @throws \Exception
     */
    public function update(ElementEventInterface $event, $eventName) {
        $this->updateWorker->updateSwoox($event, $eventName, true);
    }

    /**
     * @param ElementEventInterface $event
     * @param string                $eventName
     *
     * @throws \Exception
     */
    public function delete(ElementEventInterface $event, $eventName)
    {
        $this->updateWorker->updateSwoox($event, $eventName, false);
    }
}