<?php
/**
 * Short description for file
 *
 * Long description for file (if any)...
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       www.life-style.de
 */

namespace Publikat\Pimcore\ExportToSwooxBundle\Mapper;

use Pimcore\Model\Object\Location;
use Pimcore\Model\Object\Zone;
use Swoox\Api\Api\Manager;
use Swoox\Api\Model\Request\Delete\Swoox\Item as DeleteItem;
use Swoox\Api\Model\Request\Index\Swoox\Item as IndexItem;

/**
 * Class LocationZoneMapper
 *
 * @package Publikat\Pimcore\ExportToSwooxBundle\Mapper
 */
class LocationZoneMapper implements MapperInterface
{

    /**
     * @param      $location Location
     * @param bool $index
     *
     * @return array
     */
    public function generateOutput($location, $index)
    {
        $items = [];
        $manager = new Manager();
        /**
         * @var $zone Zone
         */
        $zone = $location->getLocationZone()[0];
        if (!$zone) {
            return [];
        }

        $languages = array_keys($zone->getLocalizedfields()->items);

        foreach ($languages as $language) {

            $localizedLocation = $location->getLocalizedfields();
            $locationName = $localizedLocation->getLocalizedValue('locationName', $language);

            $localizedZone = $zone->getLocalizedfields();
            $zoneName = $localizedZone->getLocalizedValue('zoneName', $language);


            $objectId = 'loc-' . $language . '-' . $location->getId();

            if ($index) {
                $item = new IndexItem();
                $item->setDocumentLanguage($language);
                $item->setDocumentUniqueKey($objectId);
                $item->setDocumentTitle($zoneName . ' - ' . $locationName);
                $item->setDocumentPrefix(1);
                $item->setDocumentURL('');
                $item->setDocumentRanking(1);
                $item->addDocumentFields($manager->model()->request()->index()->nameFieldList()->setName('OBJECT_TYPE')->setValue('LOCATION'));
                $item->addDocumentFields($manager->model()->request()->index()->nameFieldList()->setName('OBJECT_ID')->setValue($objectId));
                $item->addDocumentFields($manager->model()->request()->index()->nameFieldList()->setName('LANG')->setValue($language));
                $item->addDocumentFields($manager->model()->request()->index()->nameFieldList()->setName('ZONE')->setValue($zone->getId()));
                $item->addDocumentFields($manager->model()->request()->index()->nameFieldList()->setName('ZONE_NAME')->setValue($zoneName));
                $item->addDocumentFields($manager->model()->request()->index()->nameFieldList()->setName('LOCATION')->setValue($location->getId()));
                $item->addDocumentFields($manager->model()->request()->index()->nameFieldList()->setName('LOCATION_NAME')->setValue($locationName));
                $item->addDocumentFields($manager->model()->request()->index()->nameFieldList()->setName('LOCATION_TYPE')->setValue($location->getLocationType()));
                $item->addDocumentFields($manager->model()->request()->index()->nameFieldList()->setName('LOCATION_3LC')->setValue($location->getLocation3lc()));
                $item->addDocumentFields($manager->model()->request()->index()->nameFieldList()->setName('LOCATION_IFF')->setValue($location->getLocationIff()));
                $item->addDocumentFields($manager->model()->request()->index()->nameFieldList()->setName('LOCATION_GIATA')->setValue($location->getLocationGiata()));
                $item->addDocumentFields($manager->model()->request()->index()->nameFieldList()->setName('PUBLISHED')->setValue(($location->isPublished() && $zone->isPublished())));
            } else {
                $item = new DeleteItem();
                $item->setDocumentUniqueKey($objectId);
            }
            $items[] = $item;
        }

        return $items;
    }
}
