<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       www.life-style.de
 */

namespace Publikat\Pimcore\ExportToSwooxBundle\Mapper;

use Publikat\Pimcore\ExportToSwooxBundle\Webservice\Config as Config;

/**
 * Class MapperBase
 *
 * @package Publikat\Pimcore\ExportToSwooxBundle\Mapper
 */
class MapperBase
{
    /**
     * @var Config
     */
    protected $config;

    /**
     * MapperBase constructor.
     *
     * @param Config $config
     */
    public function __construct(Config $config)
    {
        $this->config = $config;
    }

    /**
     * @return Config
     */
    public function getConfig()
    {
        return $this->config;
    }
}
