<?php
/**
 * Short description for file
 *
 * Long description for file (if any)...
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       www.life-style.de
 */

namespace Publikat\Pimcore\ExportToSwooxBundle\Webservice;

/**
 * Class Config
 *
 * @package Export2Swoox\Webservice
 */
class Config
{
    /**
     * @var string
     */
    private $clientId;

    /**
     * @var string
     */
    private $name;

    /**
     * @var string
     */
    private $updateUrl;

    /**
     * @var string
     */
    private $searchUrl;

    /**
     * @var string
     */
    private $deleteUrl;

    /**
     * @var string xml|json
     */
    private $format;

    /**
     * @var string text/xml|application/json
     */
    private $contentType;

    /**
     * @var array
     */
    protected $multiClientId;

    /**
     * @var array
     */
    protected $pathConfig;

    /**
     * Config constructor.
     *
     * @param string    $baseUrl
     * @param string    $client
     * @param array     $clientMulti
     * @param array     $pathConfig
     */
    function __construct(
        $baseUrl,
        $client,
        $clientMulti,
        $pathConfig
    )
    {
        $baseUrl = trim($baseUrl);
        $this->clientId = trim($client);
        $this->multiClientId = $clientMulti[0];
        $this->format = 'json';
        $this->contentType = 'application/json';
        $this->updateUrl = "$baseUrl/api/v1/index/swoox.json";
        $this->searchUrl = "$baseUrl/api/v1/search/standard.json";
        $this->deleteUrl = "$baseUrl/api/v1/delete/swoox.json";
        $this->pathConfig = $pathConfig[0];
    }

    /**
     * @return string
     */
    public function getClientId($multi = '')
    {
        if ($multi && $this->multiClientId[$multi]) {
            return trim($this->multiClientId[$multi]);
        } else {
            return $this->clientId;
        }
    }

    /**
     * @return string
     */
    public function getAcceptContentType()
    {
        return preg_replace('/;.+/', '', $this->getContentType());
    }

    /**
     * @return string
     */
    public function getContentType()
    {
        if (preg_match('/\.(xml|json)$/', $this->updateUrl, $matches)) {
            return 'xml' == $matches[1] ? 'text/xml; charset=UTF-8' : 'application/json; charset=UTF-8';
        }

        return $this->contentType;
    }

    /**
     * @return string
     */
    public function getFormat()
    {
        return preg_match('/\.(xml|json)$/', $this->updateUrl, $matches) ? $matches[1] : $this->format;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getUpdateUrl()
    {
        return $this->updateUrl;
    }

    /**
     * @return string
     */
    public function getDeleteUrl()
    {
        return $this->deleteUrl;
    }

    /**
     * @return string
     */
    public function getSearchUrl()
    {
        return $this->searchUrl;
    }

    /**
     * @param string $searchUrl
     *
     * @return Config
     */
    public function setSearchUrl($searchUrl)
    {
        $this->searchUrl = $searchUrl;

        return $this;
    }

    /**
     * @return string
     */
    public function getMultiClientId(): string
    {
        return $this->multiClientId;
    }

    /**
     * @param string $multiClientId
     *
     * @return Config
     */
    public function setMultiClientId(string $multiClientId): Config
    {
        $this->multiClientId = $multiClientId;

        return $this;
    }

    /**
     * @return array
     */
    public function getPathConfig(): array
    {
        return $this->pathConfig;
    }

    /**
     * @param array $pathConfig
     *
     * @return Config
     */
    public function setPathConfig(array $pathConfig): Config
    {
        $this->pathConfig = $pathConfig;

        return $this;
    }
}
