<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Pimcore\ExportToSwooxBundle\Worker;

use Publikat\Pimcore\ExportToSwooxBundle\Mapper\MapperInterface;
use Publikat\Pimcore\ExportToSwooxBundle\Webservice\Request;
use Publikat\Pimcore\ExportToSwooxBundle\Webservice\Config as Config;
use Pimcore\Event\Model\DataObjectEvent;
use Pimcore\Log\ApplicationLogger;

/**
 * Class Update
 *
 * @package Publikat\Pimcore\ExportToSwooxBundle\Worker
 */
class Update
{
    /**
     * @var Request
     */
    protected $request;

    /**
     * @var Config
     */
    protected $config;

    /**
     * @var ApplicationLogger
     */
    protected $logger;

    /**
     * @var string
     */
    protected $namespace;

    /**
     * Update constructor.
     *
     * @param Request           $request
     * @param Config            $config
     * @param ApplicationLogger $logger
     * @param string            $namespace
     */
    public function __construct(Request $request, Config $config, ApplicationLogger $logger, $namespace)
    {
        $this->request = $request;
        $this->config = $config;
        $this->logger = $logger;
        $this->namespace = $namespace;
    }

    /**
     * @param DataObjectEvent $event
     * @param string          $eventName
     * @param bool            $index
     *
     * @return null|MapperInterface
     * @throws \Exception
     */
    function updateSwoox(DataObjectEvent $event, $eventName, $index = true)
    {
        $object = $event->getObject();

        if('object' !== $object->getType()) {
            return null;
        }

        /**
         * @var $mapper MapperInterface
         */
        $mapper = null;
        $className = 'Publikat\\Pimcore\\ExportToSwooxBundle\\Mapper\\' . $this->namespace . '\\' . $object->getClassName() . 'Mapper';
        $fileToInclude = __DIR__ . '/../Mapper/' . $this->namespace . '/' . $object->getClassName() . 'Mapper' . '.php';
        // Hätte gern nur class_exist einfach verwendet. Funktioniert auch aber intern wirft er im Nachgang der Pluginverarbeitung ein Fehler sofern die Klasse doch nicht existierte.
        if (file_exists($fileToInclude) && class_exists($className)) {
            // Klasse gibt es ...also darf auch etwas passieren
            // Neues Mapper Object erzeugen
            $mapper = new $className($this->config); // Nicht schön, aber...
            $eventWhitelist = $mapper->getEventWhitelist();
            if (in_array($eventName, $eventWhitelist)) {
                $this->logger->getInstance('ExportToSwoox', true)->debug("handle {$object->getClassName()} - index: {$index} - id: {$object->getId()}");
                $mapper->generateOutput($object, $index, $event);
            }
        }
        if ($mapper && sizeof($mapper->getPayload()) > 0) {
            // Ab damit nach Swoox
            $this->request->prepareAndSend($mapper, $index);
        }

        return $mapper;
    }
}
